% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.trophicSDMfit.R
\name{summary.trophicSDMfit}
\alias{summary.trophicSDMfit}
\title{Summary of a fitted trophicSDM model}
\usage{
\method{summary}{trophicSDMfit}(object, ...)
}
\arguments{
\item{object}{A trophicSDMfit object obtained with trophicSDM()}

\item{...}{additional arguments}
}
\value{
Prints a summary of the fitted trophic SDM
}
\description{
Summary of a fitted trophicSDM model
}
\examples{
data(Y, X, G)
# define abiotic part of the model
env.formula = "~ X_1 + X_2"
# Run the model with bottom-up control using stan_glm as fitting method and no penalisation
# (set iter = 1000 to obtain reliable results)
m = trophicSDM(Y, X, G, env.formula, iter = 100,
               family = binomial(link = "logit"), penal = NULL, 
               mode = "prey", method = "stan_glm")
summary(m)
}
\author{
Giovanni Poggiato
}
