% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evaluateModelFit.R
\name{evaluateModelFit}
\alias{evaluateModelFit}
\title{Evaluates prediction goodness of fit}
\usage{
evaluateModelFit(tSDM, Ynew = NULL, Ypredicted = NULL)
}
\arguments{
\item{tSDM}{A trophicSDMfit object obtained with \code{trophicSDM()}.}

\item{Ynew}{A sites x species matrix containing the true species occurrences state. If set to NULL (default), it is set to the species distribution data Y on which the model is fitted.}

\item{Ypredicted}{A sites x species matrix containing the predicted species occurrences state. If set to NULL (default), it is set to the fitted values, i.e. predictions on the dataset used to train the model.}
}
\value{
A table specifying the goodness of fit metrics for each species. For presence-absence data, the model computes TSS and AUC. For Gaussian data, the R2.
}
\description{
Evaluate goodness of fit by comparing a true versus a predicted dataset of species distribution. Ypredicted is typically predicted using a prediction method of trophicSDM (in cross-validation if \code{trophicSDM_CV()} is used).
}
\examples{
data(Y, X, G)
# define abiotic part of the model
env.formula = "~ X_1 + X_2"
# Run the model with bottom-up control using stan_glm as fitting method and no penalisation
# (set iter = 1000 to obtain reliable results)
m = trophicSDM(Y, X, G, env.formula, iter = 50,
               family = binomial(link = "logit"), penal = NULL, 
               mode = "prey", method = "stan_glm")
# Evaluate the quality of model predictions on the training
# Predict (fullPost = FALSE) as we used stan_glm to fit the model
# but here we are only intested in the posterior mean
Ypred = predict(m, fullPost = FALSE)
# format predictions to obtain a sites x species dataset whose
# columns are ordered as Ynew
Ypred = do.call(cbind,
                lapply(Ypred, function(x) x$predictions.mean))
                
Ypred = Ypred[,colnames(Y)]
evaluateModelFit(m, Ynew = Y, Ypredicted = Ypred)

# Note that this is equivalent to `evaluateModelFit(m)`
# If we fitted the model using "glm"
m = trophicSDM(Y, X, G, env.formula, iter = 50,
               family = binomial(link = "logit"), penal = NULL, 
               mode = "prey", method = "glm")
Ypred = predict(m, fullPost = FALSE)
# format predictions to obtain a sites x species dataset whose
# columns are ordered as Ynew
Ypred = do.call(cbind, Ypred)
Ypred = Ypred[,colnames(Y)]

evaluateModelFit(m, Ynew = Y, Ypredicted = Ypred)
# Note that this is equivalent to:
\donttest{
evaluateModelFit(m)
}
}
\references{
Grace, J. B., Johnson, D. J., Lefcheck, J. S., and Byrnes, J. E. K.. 2018. Quantifying relative importance: computing standardized effects in models with binary outcomes. Ecosphere 9(6):e02283.
}
\author{
Giovanni Poggiato
}
