% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cache_helpers.R
\name{wj_cache_clear}
\alias{wj_cache_clear}
\title{Clear cached weather data}
\usage{
wj_cache_clear(
  cache_dir = NULL,
  cache_scope = c("user", "project"),
  pkg = "weatherjoin",
  filter = NULL,
  keep_index = FALSE,
  dry_run = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{cache_dir}{Optional explicit cache directory.}

\item{cache_scope}{Where to store cache by default: \code{"user"} or \code{"project"}.}

\item{pkg}{Package name used for \code{"user"} cache scope.}

\item{filter}{Optional expression evaluated within the cache index to select entries to remove.}

\item{keep_index}{If \code{TRUE}, leaves index rows (useful for debugging); default \code{FALSE}.}

\item{dry_run}{If \code{TRUE}, prints what would be deleted but does not delete.}

\item{verbose}{If \code{TRUE}, prints progress.}
}
\value{
Invisibly returns the rows selected for deletion.
}
\description{
Deletes cached files and (optionally) removes rows from the cache index.
}
