% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{ww_make_point_neighbors}
\alias{ww_make_point_neighbors}
\title{Make 'nb' objects from point geometries}
\usage{
ww_make_point_neighbors(data, k = 1, sym = FALSE, ...)
}
\arguments{
\item{data}{An \code{sfc_POINT} or \code{sfc_MULTIPOINT} object.}

\item{k}{How many nearest neighbors to use in \code{\link[spdep:knearneigh]{spdep::knearneigh()}}.}

\item{sym}{Force the output neighbors list (from \code{\link[spdep:knn2nb]{spdep::knn2nb()}}) to
symmetry.}

\item{...}{Other arguments passed to \code{\link[spdep:knearneigh]{spdep::knearneigh()}}.}
}
\value{
An object of class "nb"
}
\description{
This function uses \code{\link[spdep:knearneigh]{spdep::knearneigh()}} and \code{\link[spdep:knn2nb]{spdep::knn2nb()}} to
create a "nb" neighbors list.
}
\details{
These functions can be used for geographic or projected coordinate reference
systems and expect 2D data.
}
\examples{
ww_make_point_neighbors(ny_trees)

}
