% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rename_waves_est.R
\name{rename_waves_est}
\alias{rename_waves_est}
\title{Rename wave objects and associated metadata in extended selection tables}
\usage{
rename_waves_est(X, new.sound.files, new.selec = NULL)
}
\arguments{
\item{X}{object of class 'extended_selection_table'.}

\item{new.sound.files}{Character vector of length equals to the number of rows in 'X'. Specifies the new names to be used for wave objects and sound file column. Note that this will rename wave objects and associated attributes and data in 'X'. Must be provided and must contain unique labels for each row if the extended selection table was created by element (see  \code{\link{selection_table}}). If created by song, then a single name for each sound file should be supplied.}

\item{new.selec}{Numeric or character vector of length equals to the number of rows in 'X' to specify the 'selec' column labels. Default is \code{NULL}. If not provided the 'selec' column is kept unchanged. Note that the combination of 'sound.files' and 'selec' columns must produce unique IDs for each selection (row).}
}
\value{
An extended selection table with rename sound files names in data frame and attributes. The function adds columns with the previous sound file names (and 'selec' if provided).
}
\description{
\code{rename_waves_est} rename wave objects and associated metadata in extended selection tables
}
\details{
This function allow users to change the names of 'sound.files' and 'selec' columns in extended selection tables. These names can become very long after manipulations used to produce extended tables.
}
\examples{
{ 
data("Phae.long.est")

# order by sound file name
Phae.long.est <- Phae.long.est[order(Phae.long.est$sound.files),]

# create new sound file name
nsf <- sapply(strsplit(Phae.long.est$sound.files, ".wav",fixed = TRUE), "[",1)

slc <- vector(length = nrow(Phae.long.est))
slc[1] <- 1

for(i in 2:length(slc))
if (nsf[i - 1] == nsf[i]) slc[i] <- slc[i - 1] + 1 else
slc[i] <- 1

nsf <- paste(nsf, slc, sep = "_")

# rename sound files
Y <- rename_waves_est(X = Phae.long.est, new.sound.files = nsf)
}

}
\references{
{
Araya-Salas, M., & Smith-Vidaurre, G. (2017). warbleR: An R package to streamline analysis of animal acoustic signals. Methods in Ecology and Evolution, 8(2), 184-191.
}
}
\seealso{
Other extended selection table manipulation: 
\code{\link{resample_est}()}
}
\author{
Marcelo Araya-Salas (\email{marceloa27@gmail.com})
}
\concept{extended selection table manipulation}
