% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/split_wavs.R
\name{split_wavs}
\alias{split_wavs}
\title{Splits sound files}
\usage{
split_wavs(path = NULL, sgmt.dur = 10, sgmts = NULL, files = NULL,
 parallel = 1, pb = TRUE)
}
\arguments{
\item{path}{Directory path where sound files are found. 
If \code{NULL} (default) then the current working directory is used.}

\item{sgmt.dur}{Numeric. Duration (in s) of segments in which sound files would be split. Sound files shorter than 'sgmt.dur' won't be split. Ignored if 'sgmts' is supplied.}

\item{sgmts}{Numeric. Number of segments in which to split each sound file. If supplied 'sgmt.dur' is ignored.}

\item{files}{Character vector indicating the subset of files that will be analyzed.}

\item{parallel}{Numeric. Controls whether parallel computing is applied.
It specifies the number of cores to be used. Default is 1 (i.e. no parallel computing).}

\item{pb}{Logical argument to control progress bar. Default is \code{TRUE}.}
}
\value{
Wave files for each segment in the working directory (named as 'sound.file.name-#.wav') and a data frame in the R environment containing the name of the original sound files (org.sound.files), the name of the cuts (sound.files) and the start and end of cuts in the original files.
}
\description{
\code{split_wavs} splits sound files in shorter segments
}
\details{
This function aims to reduce the size of sound files in order to simplify some processes that are limited by sound file size (big files can be manipulated, e.g. \code{\link{auto_detec}} ).
}
\examples{
{
#load data and save to temporary working directory
data(list = c("Phae.long1", "Phae.long2", "Phae.long3"))
writeWave(Phae.long1, file.path(tempdir(), "Phae.long1.wav"))
writeWave(Phae.long2, file.path(tempdir(), "Phae.long2.wav"))
writeWave(Phae.long3, file.path(tempdir(), "Phae.long3.wav"))

#split files in 1 s files
split_wavs(sgmt.dur = 1, path = tempdir())

# Check this folder
tempdir()
}

}
\references{
{
Araya-Salas, M., & Smith-Vidaurre, G. (2017). warbleR: An R package to streamline analysis of animal acoustic signals. Methods in Ecology and Evolution, 8(2), 184-191.
}
}
\seealso{
\code{\link{cut_sels}}

Other data manipulation: \code{\link{move.imgs}},
  \code{\link{open_wd}}
}
\author{
Marcelo Araya-Salas (\email{marceloa27@gmail.com})
}
\concept{data manipulation}
