% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mp32wav.R
\name{mp32wav}
\alias{mp32wav}
\title{Convert .mp3 files to .wav}
\usage{
mp32wav(samp.rate = 44.1, parallel = 1, from = NULL,path = NULL, 
to = NULL, dest.path = NULL, normalize = NULL, pb = TRUE, overwrite = FALSE)
}
\arguments{
\item{samp.rate}{Sampling rate at which the .wav files should be written. The maximum permitted is 44.1 kHz (default). Units should be kHz.}

\item{parallel}{Numeric. Controls whether parallel computing is applied.
It specifies the number of cores to be used. Default is 1 (i.e. no parallel computing).}

\item{from}{Character string containing the directory path where the .mp3 files are located. Will be deprecated in future versions.}

\item{path}{Character string containing the directory path where the .mp3 files are located.
If \code{NULL} (default) then the current working directory is used. Same as
'from' (will replace it in future versions).}

\item{to}{Character string containing the directory path where the .wav files will be saved. 
If \code{NULL} (default) then the current working directory is used. Will be deprecated in future versions.}

\item{dest.path}{Character string containing the directory path where the .wav files will be saved. 
If \code{NULL} (default) then the current working directory is used. Same as 'to' (will replace it in future versions).}

\item{normalize}{Character string containing the units to be used for amplitude normalization. Check 
(\code{\link[tuneR]{normalize}}) for details. If NULL (default) no normalization is carried out.}

\item{pb}{Logical argument to control progress bar. Default is \code{TRUE}.}

\item{overwrite}{Logical. Control whether a .wav sound file that is already in the working directory should be 
overwritten.}
}
\value{
.wav files saved in the working directory with same name as original mp3 files.
}
\description{
\code{mp32wav} converts several .mp3 files in working directory to .wav format
}
\details{
convert all .mp3 files in working directory to .wav format. Function used internally to read .mp3 files (\code{\link[tuneR]{readMP3}}) sometimes crashes.
}
\examples{
\dontrun{
# First set temporary folder
# setwd(tempdir())
 
#Then download mp3 files from xeno-canto
querxc(qword = "Phaethornis aethopygus", download = TRUE)

# Convert all files to .wav format
mp32wav()

#check this folder!!
getwd()
}
}
\author{
Marcelo Araya-Salas (\email{araya-salas@cornell.edu}) and Grace Smith Vidaurre
}
