% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/xcmaps.R
\name{xcmaps}
\alias{xcmaps}
\title{Maps of Xeno-Canto recordings by species}
\usage{
xcmaps(X, img = TRUE, it = "jpeg", res = 100)
}
\arguments{
\item{X}{Data frame output from \code{\link{querxc}}.}

\item{img}{A logical argument specifying whether an image file of each species
map should be returned, default is \code{TRUE}.}

\item{it}{A character vector of length 1 giving the image type to be used. Currently only
"tiff" and "jpeg" are admitted. Default is "jpeg".}

\item{res}{Numeric argument of length 1. Controls image resolution.
Default is 100 (faster) although 300 - 400 is recommended for publication/
presentation quality.}
}
\value{
A map of Xeno-Canto recordings per species (image file), or a faceted
  plot of species map(s) in the active graphic device.
}
\description{
\code{xcmaps} creates maps to visualize the geographic spread of Xeno-Canto
  recordings.
}
\details{
This function creates maps for visualizing the geographic spread of recordings from the open-access
online repository Xeno-Canto (\url{http://www.xeno-canto.org/}). The function takes the output of
\code{\link{querxc}} as input. Maps can be displayed in the graphic devide or saved as images in the
working directory.
}
\examples{
\dontrun{
X <- querxc("Phaethornis anthophilus", download = FALSE)
View(X)
xcmaps(X)
xcmaps(X, img = FALSE, it = "jpeg")
}
}
\author{
Marcelo Araya-Salas (\url{http://marceloarayasalas.weebly.com/}) and Grace Smith Vidaurre
}

