% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/poccs_removeByID.R
\name{poccs_removeByID}
\alias{poccs_removeByID}
\title{poccs_removeByID Remove occurrence by ID}
\usage{
poccs_removeByID(occs, removeID, logger = NULL, spN = NULL)
}
\arguments{
\item{occs}{data frame of cleaned occurrences obtained from component occs:
Obtain occurrence data}

\item{removeID}{the ID of the occurrence to be removed from the occurrences
dataframe.}

\item{logger}{Stores all notification messages to be displayed in the Log
Window of Wallace GUI. Insert the logger reactive list here for running in
shiny, otherwise leave the default NULL}

\item{spN}{data frame of cleaned occurrences obtained from component occs:
Obtain occurrence data. Used to obtain species name for logger messages.}
}
\value{
A new occurence dataframe without the user selected occurrence
  mantaining all columns from original dataframe for further analyses.
}
\description{
This function removes user selected occurrences by ID.
}
\details{
This function is called by the remove occurrences by ID module. It allows for
  removal of a single occurrence flagged by the user on the map. The function
  will return a data frame of occurrences with all relevant columns for
  further analyses and without the occurrence selected by the user.
}
\examples{
occs <- read.csv(system.file("extdata/Bassaricyon_neblina.csv",
                 package = "wallace"))[, 2:3]
occs$occID <- 1:nrow(occs)
out.ID <- poccs_removeByID(occs, 11)

}
\author{
Jamie Kass <jamie.m.kass@gmail.com>

Gonzalo E. Pinilla-Buitrago <gpinillabuitrago@gradcenter.cuny.edu>
}
