% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pp_check.R
\name{pp_check.walker_fit}
\alias{pp_check.walker_fit}
\title{Posterior predictive check for walker object}
\usage{
\method{pp_check}{walker_fit}(object, ...)
}
\arguments{
\item{object}{An output from \code{\link{walker}}.}

\item{...}{Further parameters to \code{\link{ppc_ribbon}}.}
}
\description{
Plots sample quantiles from posterior predictive sample.
}
\details{
For other types of posterior predictive checks for example with \code{bayesplot}, 
you can extract the variable \code{yrep} from the output, see examples.#'
}
\examples{
\dontrun{
# Extracting the yrep variable for general use:
# extract yrep
y_rep <- extract(object$stanfit, pars = "y_rep", permuted = TRUE)$y_rep

# For non-gaussian model:
weights <- extract(object$stanfit, pars = "weights", permuted = TRUE)$weights
y_rep <- y_rep[sample(1:nrow(y_rep), 
  size = nrow(y_rep), replace = TRUE, prob = weights), , drop = FALSE]
}

}
