% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parameters.R
\docType{data}
\name{constants}
\alias{constants}
\title{List of Constants
\code{non_wearing_min_threshold_epochs} Number of consecutive epochs with activity counts of 0 that constitute a non_wearing period.
\code{min_wearing_hours_per_day} Minimum number of hours in a day an individual must wear an accelerometer for the day to be considered complete.
\code{min_gps_obs_within_bout} Minimum number of GPS observations within a bout for that bout to be considered to have complete GPS data.
\code{min_gps_coverage_ratio} Minimum ratio of data points with versus without GPS data for the bout to be considered to have complete GPS data.
\code{dwellbout_radii_quantile} Threshold for outliering GPS data points - any data points above the 95th percentile are outliered.
\code{max_dwellbout_radii_ft} Maximum radius, in feet, of a bounding circle that would be considered a dwell bout (rather than a potential walk bout).
\code{min_dwellbout_obs} Minimum number of observations to consider something a potential dwell bout.
\code{max_walking_cpe} Maxiumum CPE value before the accelerometer is considered to be picking up on an activity other than walking.
\code{min_walking_speed_km_h} Minimum speed considered walking.
\code{max_walking_speed_km_h} Maximum speed considered walking.}
\format{
An object of class \code{list} of length 10.
}
\usage{
constants
}
\description{
List of Constants
\code{non_wearing_min_threshold_epochs} Number of consecutive epochs with activity counts of 0 that constitute a non_wearing period.
\code{min_wearing_hours_per_day} Minimum number of hours in a day an individual must wear an accelerometer for the day to be considered complete.
\code{min_gps_obs_within_bout} Minimum number of GPS observations within a bout for that bout to be considered to have complete GPS data.
\code{min_gps_coverage_ratio} Minimum ratio of data points with versus without GPS data for the bout to be considered to have complete GPS data.
\code{dwellbout_radii_quantile} Threshold for outliering GPS data points - any data points above the 95th percentile are outliered.
\code{max_dwellbout_radii_ft} Maximum radius, in feet, of a bounding circle that would be considered a dwell bout (rather than a potential walk bout).
\code{min_dwellbout_obs} Minimum number of observations to consider something a potential dwell bout.
\code{max_walking_cpe} Maxiumum CPE value before the accelerometer is considered to be picking up on an activity other than walking.
\code{min_walking_speed_km_h} Minimum speed considered walking.
\code{max_walking_speed_km_h} Maximum speed considered walking.
}
\keyword{datasets}
