% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export.R
\name{wal.export.to.png}
\alias{wal.export.to.png}
\title{Export wal instance to PNG format image file.}
\usage{
wal.export.to.png(wal, filepath, apply_palette = wal::pal_q2(), ...)
}
\arguments{
\item{wal}{a wal instance, as returned by \code{read.wal}}

\item{filepath}{character string, path to the PNG file to write, including the file extension.}

\item{apply_palette}{optional 256 x 3 integer matrix, the palette. Must contain values in range 0..255. Pass NULL if you do not want to apply any palette. The resulting \code{wal} object will not have an 'image' entry then.}

\item{...}{extra parameters passed to \code{png::writePNG}.}
}
\description{
Export wal instance to PNG format image file.
}
\examples{
\dontrun{
   walf = '~/data/q2_pak0_extracted/textures/e1u2/basic1_7.wal';
   wal = read.wal(walf);
   wal.export.to.png(wal, "~/basic1_7.png");
}

}
