% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/r_sample.R
\name{r_sample}
\alias{r_sample}
\title{Generate Random Vector}
\usage{
r_sample(n, x = 1:100, prob = NULL, name = "Sample")
}
\arguments{
\item{n}{The number elements to generate.  This can be globally set within
the environment of \code{r_data_frame} or \code{r_list}.}

\item{x}{A vector of elements to chose from.}

\item{prob}{A vector of probabilities to chose from.}

\item{name}{The name to assign to the output vector's \code{varname}
attribute.  This is used to auto assign names to the column/vector name when
used inside of \code{r_data_frame} or \code{r_list}.}
}
\value{
Returns a random vector of elements.
}
\description{
Generate a random vector.
}
\examples{
r_sample(100, name = "Var")
table(r_sample(x = c("Dog", "Cat", "Fish", "Bird"), n=1000))
r_sample(x = c("B", "W"), prob = c(.7, .3), n = 25, name = "Race")
r_sample(25, x = c(TRUE, FALSE))
}
\seealso{
\code{\link[base]{sample}}
}

