% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/waiter.R
\name{waiterClass}
\alias{waiterClass}
\alias{Waiter}
\title{Waiter R6 Class}
\description{
Create a waiter to then show, hide or update its content.
}
\details{
Create an object to show a waiting screen on either the entire application
or just a portion of the app by specifying the \code{id}. Then \code{show},
then \code{hide} or meanwhile \code{update} the content of the waiter.
}
\examples{

## ------------------------------------------------
## Method `Waiter$new`
## ------------------------------------------------

\dontrun{Waiter$new()}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{Waiter$new()}}
\item \href{#method-show}{\code{Waiter$show()}}
\item \href{#method-hide}{\code{Waiter$hide()}}
\item \href{#method-update}{\code{Waiter$update()}}
\item \href{#method-print}{\code{Waiter$print()}}
\item \href{#method-clone}{\code{Waiter$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Waiter$new(
  id = NULL,
  html = NULL,
  color = NULL,
  logo = NULL,
  image = "",
  hide_on_render = !is.null(id),
  hide_on_error = !is.null(id),
  hide_on_silent_error = !is.null(id)
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{Id, or vector of ids, of element on which to overlay the waiter, if \code{NULL} the waiter is
applied to the entire body.}

\item{\code{html}}{HTML content of waiter, generally a spinner, see \code{\link{spinners}} or a list of the latter.}

\item{\code{color}}{Background color of loading screen.}

\item{\code{logo}}{Logo to display.}

\item{\code{image}}{Path to background image of loading screen.}

\item{\code{hide_on_render}}{Set to \code{TRUE} to automatically hide the waiter
when the element in \code{id} is drawn. Note the latter will work with
shiny plots, tables, htmlwidgets, etc. but will not work with arbitrary
elements.}

\item{\code{hide_on_error, hide_on_silent_error}}{Whether to hide the waiter when the underlying element throws an error.
Silent error are thrown by \link[shiny]{req} and  \link[shiny]{validate}.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Create a waiter.
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{Waiter$new()}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-show"></a>}}
\if{latex}{\out{\hypertarget{method-show}{}}}
\subsection{Method \code{show()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Waiter$show()}\if{html}{\out{</div>}}
}

\subsection{Details}{
Show the waiter.
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-hide"></a>}}
\if{latex}{\out{\hypertarget{method-hide}{}}}
\subsection{Method \code{hide()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Waiter$hide()}\if{html}{\out{</div>}}
}

\subsection{Details}{
Hide the waiter.
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-update"></a>}}
\if{latex}{\out{\hypertarget{method-update}{}}}
\subsection{Method \code{update()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Waiter$update(html = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{html}}{HTML content of waiter, generally a spinner, see \code{\link{spinners}}.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Update the waiter's html content.
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-print"></a>}}
\if{latex}{\out{\hypertarget{method-print}{}}}
\subsection{Method \code{print()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Waiter$print()}\if{html}{\out{</div>}}
}

\subsection{Details}{
print the waiter
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Waiter$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
