% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/waiter.R
\name{waiter}
\alias{waiter}
\alias{use_waiter}
\alias{waiter_use}
\alias{show_waiter}
\alias{waiter_show}
\alias{show_waiter_on_load}
\alias{waiter_show_on_load}
\alias{hide_waiter_on_drawn}
\alias{waiter_hide_on_render}
\alias{hide_waiter}
\alias{waiter_hide}
\alias{update_waiter}
\alias{waiter_update}
\title{Waiter}
\usage{
use_waiter(include_js = TRUE)

waiter_use(include_js = TRUE)

show_waiter(
  html = "",
  color = "#333e48",
  logo = "",
  id = NULL,
  hide_on_render = FALSE
)

waiter_show(
  id = NULL,
  html = spin_1(),
  color = "#333e48",
  logo = "",
  hide_on_render = !is.null(id)
)

show_waiter_on_load(html = "", color = "#333e48", logo = "")

waiter_show_on_load(html = spin_1(), color = "#333e48", logo = "")

hide_waiter_on_drawn(id)

waiter_hide_on_render(id)

hide_waiter(id = NULL)

waiter_hide(id = NULL)

update_waiter(html = "", id = NULL)

waiter_update(id = NULL, html = NULL)
}
\arguments{
\item{include_js}{Whether to include the Javascript dependencies, only
set to \code{FALSE} if you use \code{\link{show_waiter_on_load}}.}

\item{html}{HTML content of waiter, generally a spinner, see \code{\link{spinners}}.}

\item{color}{Background color of loading screen.}

\item{logo}{Logo to display.}

\item{id}{Id of element to hide or element on which to show waiter over.}

\item{hide_on_render}{Set to \code{TRUE} to automatically hide the waiter
when the plot in \code{id} is drawn. Note the latter will only work with
shiny plots, tables, htmlwidgets, etc. but will not work with arbitrary
elements.}
}
\description{
Programatically show and hide loading screens.
}
\section{Functions}{

\itemize{
 \item{\code{use_waiter} and \code{waiter_use}: waiter dependencies to include anywhere in your UI but ideally at the top.}
 \item{\code{waiter_show_on_load}: Show a waiter on page load, before the session is even loaded, include in UI \emph{after} \code{use_waiter}.}
 \item{\code{waiter_show}: Show waiting screen.}
 \item{\code{waiter_hide}: Hide any waiting screen.}
 \item{\code{waiter_update}: Update the content \code{html} of the waiting screen.}
 \item{\code{waiter_hide_on_render}: Hide any waiting screen when the output is drawn, useful for outputs that take a long time to draw, \emph{use in \code{ui}}.}
}
}

\examples{
library(shiny)

ui <- fluidPage(
  use_waiter(), # dependencies
  waiter_show_on_load(spin_fading_circles()), # shows before anything else 
  actionButton("show", "Show loading for 5 seconds")
)

server <- function(input, output, session){
  waiter_hide() # will hide *on_load waiter
  
  observeEvent(input$show, {
    waiter_show(
      tagList(
        spin_fading_circles(),
        "Loading ..."
      )
    )
    Sys.sleep(3)
    waiter_hide()
  })
}

if(interactive()) shinyApp(ui, server)

}
