#' @title Cut.off
#' @description Computes the cutoff threshold using the descriptive values generated by the bootsrap, also plots the empirical distribution and the sample wTO.
#' @param wTO_value is the table returned by the wTO with all the simulated values.
#' @param main title of the graph.
#' @return plots in a new device the cutoff value, and the amount of links in each one of the bands.
#' @keywords internal
#' @import graphics
#' @importFrom stats density quantile
#'
#'


Cut.off = function(wTO_value, type){
  `%ni%` <- Negate(`%in%`)
  star_cors = wTO_value[,-c(1:3)]
  cors_real = wTO_value[, 1:3]
  Star_density = stats::density(as.vector(t(star_cors)))
  Real_density = stats::density(as.vector(cors_real$wTO_0))

  minmax_star = cbind(min(as.vector(t(star_cors))), max(as.vector(t(star_cors))))
  quantile_real = stats::quantile(as.vector(cors_real$wTO_0), c(0.001,
                                                         0.025,
                                                         0.10,
                                                         0.9,
                                                         0.975,
                                                         0.999
                                                         ))
  quantile_star = stats::quantile(as.vector(t(star_cors)), c(0.001,
                                                         0.025,
                                                         0.10,
                                                         0.9,
                                                         0.975,
                                                         0.999
  ))

  graphics::par(xpd=FALSE)
  graphics::plot(Star_density$x, Star_density$y, type = "l",
       xlim = c(floor(min (Star_density$x, Real_density$x) ),1),
       main = type,
       ylim = c(0, max(Star_density$y, Real_density$y)), axes = F,
       xlab = "wTO", ylab = "Density", col.main = "steelblue2", col.lab = "steelblue2")
  graphics::lines(Real_density$x, Real_density$y, type = "l", col = "violet")
  graphics::abline(h = 0, col = "gray", lty = 4)


  graphics::abline(v = c(quantile_real), col = c("red", "orange", "yellow", "yellow", "orange", "red"
                                                 ), lty = 2)

  graphics::axis(1, las = 1, cex.axis = 0.6, col = "steelblue",

                 col.ticks = "steelblue3", col.axis = "steelblue")
  graphics::axis(2, las = 1, cex.axis = 0.6, col = "steelblue",col.ticks = "steelblue3", col.axis = "steelblue")
  graphics::par(xpd=T)
  graphics::legend(c(0.9,max(Star_density$y)), c("wTO - Data set",
                                 "wTO - Reshuffle",

                                 "99.9%",
                                 "95%",
                                 "80%"),
                   inset=c(-0.8,0),lwd = 2,
                   lty = 1, col = c("violet",
                                     "black",

                                    "yellow", "orange", "red"), bty = "n", cex = 0.5  )

# print(paste("Results for", type))
#   print(paste0("The thresholds for the resampling are:"))
#   print(minmax_star)
#   print(paste0("The quantiles for the real values are:"))
#   print(quantile_real)
  return(list(Empirical.Quantile = quantile_star, Quantile = quantile_real))
}
