% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_dataset_summary_table.R
\name{find_maximum_value}
\alias{find_maximum_value}
\title{Find the maximum numeric value in a vector, ignoring non-numeric values}
\usage{
find_maximum_value(numeric_vector)
}
\arguments{
\item{numeric_vector}{A vector from which to find the maximum numeric value.}
}
\value{
The maximum numeric value in the input vector, or NA if none exist.
}
\description{
Find the maximum numeric value in a vector, ignoring non-numeric values
}
\examples{
# Find the maximum of a numeric vector
find_maximum_value(c(3, 1, 4, 1, 5, 9)) # Returns   9

# Find the maximum of a mixed vector with non-numeric values
find_maximum_value(c(3, 1, 4, "two", 5, 9)) # Returns   9

# Attempt to find the maximum of a vector with only non-numeric values
find_maximum_value(c("one", "two", "three")) # Returns NA
}
