% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/design_missing_Z.R
\name{design_missingness_treatment}
\alias{design_missingness_treatment}
\title{Design a simple treatment plan to indicate missingingness and perform simple imputation.}
\usage{
design_missingness_treatment(
  dframe,
  ...,
  varlist = colnames(dframe),
  invalid_mark = "_invalid_",
  drop_constant_columns = FALSE,
  missingness_imputation = NULL,
  imputation_map = NULL
)
}
\arguments{
\item{dframe}{data.frame to drive design.}

\item{...}{not used, forces later arguments to bind by name.}

\item{varlist}{character, names of columns to process.}

\item{invalid_mark}{character, name to use for NA levels and novel levels.}

\item{drop_constant_columns}{logical, if TRUE drop columns that do not vary from the treatment plan.}

\item{missingness_imputation}{function of signature f(values: numeric), simple missing value imputer.}

\item{imputation_map}{map from column names to functions of signature f(values: numeric), simple missing value imputers.}
}
\value{
simple treatment plan.
}
\description{
Design a simple treatment plan to indicate missingingness and perform simple imputation.
}
\examples{

d <- wrapr::build_frame(
  "x1", "x2", "x3" |
  1   , 4   , "A"  |
  NA  , 5   , "B"  |
  3   , 6   , NA   )

plan <- design_missingness_treatment(d)
prepare(plan, d)

prepare(plan, data.frame(x1=NA, x2=NA, x3="E"))

}
\seealso{
\code{\link{prepare.simple_plan}}
}
