% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/outOfSample.R
\name{makekWayCrossValidationGroupedByColumn}
\alias{makekWayCrossValidationGroupedByColumn}
\title{Build a k-fold cross validation splitter, respecting (never splitting) groupingColumn.}
\usage{
makekWayCrossValidationGroupedByColumn(groupingColumnName)
}
\arguments{
\item{groupingColumnName}{name of column to group by.}
}
\value{
splitting function in the sense of vtreat::buildEvalSets.
}
\description{
Build a k-fold cross validation splitter, respecting (never splitting) groupingColumn.
}
\examples{

d <- data.frame(y=sin(1:100))
d$group <- floor(seq_len(nrow(d))/5)
splitter <- makekWayCrossValidationGroupedByColumn('group')
split <- splitter(nrow(d),5,d,d$y)
d$splitLabel <- vtreat::getSplitPlanAppLabels(nrow(d),split)
rowSums(table(d$group,d$splitLabel)>0)

}

