% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/outOfSample.R
\name{makekWayCrossValidationOrderedByColumn}
\alias{makekWayCrossValidationOrderedByColumn}
\title{Build a k-fold cross validation splitter, respecting (train always above test) orderColumn}
\usage{
makekWayCrossValidationOrderedByColumn(orderColumnName)
}
\arguments{
\item{orderColumnName}{name of column to order by.}
}
\value{
splitting function in the sense of vtreat::buildEvalSets.
}
\description{
Build a k-fold cross validation splitter, respecting (train always above test) orderColumn
}
\examples{

d <- data.frame(y=sin(1:100))
d$order <- seq_len(nrow(d))
splitter <- makekWayCrossValidationOrderedByColumn('order')
split <- splitter(nrow(d),5,d,d$y)
for(si in split) {
   print(paste(max(si$train),min(si$app)))
}

}

