% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/labeltable.R
\name{labeltable}
\alias{labeltable}
\title{Label Table Function}
\usage{
labeltable(var, ..., out = NA, file = NA, desc = NA)
}
\arguments{
\item{var}{A vector. Label table will show, for each of the values of this variable, its label (if labels can be found with sjlabelled::get_labels()), or the values in the ... variables.}

\item{...}{As described above. If specified, will show the values of these variables, instead of the labels of var, even if labels can be found.}

\item{out}{Determines where the completed table is sent. Set to "browser" to open HTML file in browser using browseURL(), "viewer" to open in RStudio viewer using viewer(), if available. Use "htmlreturn" to return the HTML code to R, or "return" to return the completed variable table to R in data frame form. Defaults to "viewer" if RStudio is running and "browser" if it isn't.}

\item{file}{Saves the completed variable table file to HTML with this filepath. May be combined with any value of out.}

\item{desc}{Description of variable (or labeling system) to be included with the table.}
}
\description{
This function output a descriptive table listing, for each value of a given variable, either the label of that value, or all values of another variable associated with that value. The table is output either to the console or as an HTML file that can be viewed continuously while working with data.
}
\details{
Outputting the label table as a help file will make it easy to search through value labels, or to see the correspondence between the values of one variable and the values of another.

Labels that are not in the data will also be reported in the table.
}
\examples{
\dontshow{
#These tests use the out='htmlreturn' option
#so that the same process of generating HTML is followed
#but a browser window is not opened during testing.
#This process is identical to regular operation except that
#HTML is written to the R output rather than a browser.

#Input a single labelled variable to see a table relating values to labels.
#Values not present in the data will be included in the table but moved to the end.
library(sjlabelled)
data(efc)
labeltable(efc$e15relat,out='htmlreturn')

#Include multiple variables to see, for each value of the first variable,
#each value of the others present in the data.
data(efc)
labeltable(efc$e15relat,efc$e16sex,efc$e42dep,out='htmlreturn')

#Commonly, the multi-variable version might be used to recover the original
#values of encoded variables
data(USJudgeRatings)
USJudgeRatings$Judge <- row.names(USJudgeRatings)
USJudgeRatings$JudgeID <- as.numeric(as.factor(USJudgeRatings$Judge))
labeltable(USJudgeRatings$JudgeID,USJudgeRatings$Judge,out='htmlreturn')
}
if(interactive()){
#Input a single labelled variable to see a table relating values to labels.
#Values not present in the data will be included in the table but moved to the end.
library(sjlabelled)
data(efc)
labeltable(efc$e15relat)

#Include multiple variables to see, for each value of the first variable,
#each value of the others present in the data.
data(efc)
labeltable(efc$e15relat,efc$e16sex,efc$e42dep)

#Commonly, the multi-variable version might be used to recover the original
#values of encoded variables
data(USJudgeRatings)
USJudgeRatings$Judge <- row.names(USJudgeRatings)
USJudgeRatings$JudgeID <- as.numeric(as.factor(USJudgeRatings$Judge))
labeltable(USJudgeRatings$JudgeID,USJudgeRatings$Judge)
}
}
