% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/col_types.R
\name{cols}
\alias{cols}
\alias{cols_only}
\alias{col_logical}
\alias{col_integer}
\alias{col_double}
\alias{col_character}
\alias{col_skip}
\alias{col_number}
\alias{col_guess}
\alias{col_factor}
\alias{col_datetime}
\alias{col_date}
\alias{col_time}
\title{Create column specification}
\usage{
cols(..., .default = col_guess())

cols_only(...)

col_logical(...)

col_integer(...)

col_double(...)

col_character(...)

col_skip(...)

col_number(...)

col_guess(...)

col_factor(levels = NULL, ordered = FALSE, include_na = FALSE, ...)

col_datetime(format = "", ...)

col_date(format = "", ...)

col_time(format = "", ...)
}
\arguments{
\item{...}{Either column objects created by \code{col_*()}, or their abbreviated
character names (as described in the \code{col_types} argument of
\code{\link[=vroom]{vroom()}}). If you're only overriding a few columns, it's
best to refer to columns by name. If not named, the column types must match
the column names exactly. In \code{col_*()} functions these are stored in the
object.}

\item{.default}{Any named columns not explicitly overridden in \code{...}
will be read with this column type.}

\item{levels}{Character vector providing set of allowed levels. if \code{NULL},
will generate levels based on the unique values of \code{x}, ordered by order
of appearance in \code{x}.}

\item{ordered}{Is it an ordered factor?}

\item{include_na}{If \code{NA} are present, include as an explicit factor to level?}

\item{format}{A format specification, as described below. If set to "",
date times are parsed as ISO8601, dates and times used the date and
time formats specified in the \code{\link[=locale]{locale()}}.

Unlike \code{\link[=strptime]{strptime()}}, the format specification must match
the complete string.}
}
\description{
\code{cols()} includes all columns in the input data, guessing the column types
as the default. \code{cols_only()} includes only the columns you explicitly
specify, skipping the rest.
}
\details{
The available specifications are: (with string abbreviations in brackets)
\itemize{
\item \code{col_logical()} [l], containing only \code{T}, \code{F}, \code{TRUE} or \code{FALSE}.
\item \code{col_integer()} [i], integers.
\item \code{col_double()} [d], doubles.
\item \code{col_character()} [c], everything else.
\item \code{col_factor(levels, ordered)} [f], a fixed set of values.
\item \code{col_date(format = "")} [D]: with the locale's \code{date_format}.
\item \code{col_time(format = "")} [t]: with the locale's \code{time_format}.
\item \code{col_datetime(format = "")} [T]: ISO8601 date times
\item \code{col_number()} [n], numbers containing the \code{grouping_mark}
\item \code{col_skip()} [_, -], don't import this column.
\item \code{col_guess()} [?], parse using the "best" type based on the input.
}
}
\examples{
cols(a = col_integer())
cols_only(a = col_integer())

# You can also use the standard abbreviations
cols(a = "i")
cols(a = "i", b = "d", c = "_")

# You can also use multiple sets of column definitions by combining
# them like so:

t1 <- cols(
  column_one = col_integer(),
  column_two = col_number())

t2 <- cols(
 column_three = col_character())

t3 <- t1
t3$cols <- c(t1$cols, t2$cols)
t3
}
