% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gammVoxel.R
\name{gammVoxel}
\alias{gammVoxel}
\title{Run a Generalized Additive Mixed Effects Model on all voxels of a NIfTI image within a mask.}
\usage{
gammVoxel(image, mask, fourdOut = NULL, formula, randomFormula, subjData,
  mc.preschedule = TRUE, ncores = 1, ...)
}
\arguments{
\item{image}{Input image of type 'nifti' or vector of path(s) to images. If multiple paths, the script will call mergeNifti() and merge across time.}

\item{mask}{Input mask of type 'nifti' or path to mask. Must be a binary mask}

\item{fourdOut}{To be passed to mergeNifti, This is the path and file name without the suffix to save the fourd file. Default (NULL) means script won't write out 4D image.}

\item{formula}{Must be a formula passed to gamm4()}

\item{randomFormula}{Random effects formula passed to gamm4()}

\item{subjData}{Dataframe containing all the covariates used for the analysis}

\item{mc.preschedule}{Argument to be passed to mclapply, whether or not to preschedule the jobs. More info in parallel::mclapply}

\item{ncores}{Number of cores to use}

\item{...}{Additional arguments passed to gamm4()}
}
\value{
Returns list of models fitted to each voxel over the masked images passed to function.
}
\description{
This function is able to run a Generalized Mixed Effects Model (GAMM) using the gamm4() function. 
The analysis will run in all voxels within the mask and will return the model fit for each voxel.
}
\examples{


image <- oro.nifti::nifti(img = array(1:1600, dim =c(4,4,4,25)))
mask <- oro.nifti::nifti(img = array(c(rep(0,14),1), dim = c(4,4,4,1)))
set.seed(1)
covs <- data.frame(x = runif(25), id = rep(1:5,5))
fm1 <- "~ s(x)"
randomFormula <- "~(1|id)"
models <- gammVoxel(image = image , mask = mask, formula = fm1, randomFormula = randomFormula, 
                                                       subjData = covs, ncores = 1, REML=TRUE)

}
\keyword{internal}
