% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lmVoxel.R
\name{lmVoxel}
\alias{lmVoxel}
\title{Run a Linear Model on all voxels of a NIfTI image within a mask.}
\usage{
lmVoxel(image, mask, fourdOut = NULL, formula, subjData,
  mc.preschedule = TRUE, ncores = 1, ...)
}
\arguments{
\item{image}{Input image of type 'nifti' or vector of path(s) to images. If multiple paths, the script will all mergeNifti() and merge across time.}

\item{mask}{Input mask of type 'nifti' or path to mask. Must be a binary mask}

\item{fourdOut}{To be passed to mergeNifti, This is the path and file name without the suffix to save the fourd file. Default (NULL) means script won't write out 4D image.}

\item{formula}{Must be a formula passed to lm()}

\item{subjData}{Dataframe containing all the covariates used for the analysis}

\item{mc.preschedule}{Argument to be passed to mclapply, whether or not to preschedule the jobs. More info in parallel::mclapply}

\item{ncores}{Number of cores to use}

\item{...}{Additional arguments passed to lm()}
}
\value{
Returns list of models fitted to each voxel over the masked images passed to function.
}
\description{
This function is able to run a Linear Model using the stats package. 
The analysis will run in all voxels in in the mask and will return the model fit for each voxel.
}
\examples{
image <- oro.nifti::nifti(img = array(1:1600, dim =c(4,4,4,25)))
mask <- oro.nifti::nifti(img = array(0:1, dim = c(4,4,4,1)))
set.seed(1)
covs <- data.frame(x = runif(25))
fm1 <- "~ x"
models <- lmVoxel(image=image, mask=mask, 
              formula=fm1, subjData=covs, ncores = 1)
}

