% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/approval_method.R
\name{approval_method}
\alias{approval_method}
\title{Approval Method}
\usage{
approval_method(x, min_valid = 1, n)
}
\arguments{
\item{x}{an object of class \code{vote}.}

\item{min_valid}{default is 1. If the number of valid entries of 
a ballot is less than this value, the ballot will not be used.}

\item{n}{the number of candidates written down by a 
voter should not larger than this value.}
}
\value{
a list object.
\itemize{
  \item (1) \code{call} the function call.
  \item (2) \code{method} the counting method.
  \item (3) \code{candidate} candidate names.
  \item (4) \code{candidate_num} number of candidate.
  \item (5) \code{ballot_num} number of ballots in x.
  \item (6) \code{valid_ballot_num} number of ballots that are 
used to compute the result.
  \item (7) \code{winner} the winners, may be one, more than one or NULL.
  \item (8) \code{n} equal to the argument \code{n}.
  \item (9) \code{other_info} frequencies of candidates mentioned 
by voters.
}
}
\description{
In approval method, each voter is required to mention 
one or more candidates, and the winner is the one 
who gets the top frequency. For this function, a ballot 
with candidates more than required and 
different scores is also valid. For a score matrix, the function will 
check the positions j, k...which have the 
lowest scores (in a \code{vote} object, 
the lower, the better) in the ith row. However, the function will 
first check the \code{approval_able} element of 
the \code{vote} object. If it is FALSE, the winner will be NULL.
}
\examples{
raw <- matrix(NA, nrow = 22, ncol = 5)
for (i in 1: 20){
   set.seed(i)
   raw[i, ] <- sample(c(1: 5, NA, NA, NA), 5)
}
raw[21, ] <- c(4, 5, 3, 1, 2)
raw[22, ] <- c(3, 5, 1, 2, 4)
vote <- create_vote(raw, xtype = 1)
y <- approval_method(vote, n = 3)
y <- approval_method(vote, n = 3, min_valid = 5)
y <- approval_method(vote, n = 4, min_valid = 3)
}
