% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Create.actor.twitter.R
\name{Create.actor.twitter}
\alias{Create.actor.twitter}
\title{Create twitter actor network}
\usage{
\method{Create}{actor.twitter}(datasource, type, verbose = TRUE, ...)
}
\arguments{
\item{datasource}{Collected social media data with \code{"datasource"} and \code{"twitter"} class names.}

\item{type}{Character string. Type of network to be created, set to \code{"actor"}.}

\item{verbose}{Logical. Output additional information about the network creation. Default is \code{TRUE}.}

\item{...}{Additional parameters passed to function. Not used in this method.}
}
\value{
Network as a named list of two dataframes containing \code{$nodes} and \code{$edges}.
}
\description{
Creates a twitter actor network from tweets returned from the twitter search query. Twitter users who 
have tweeted / retweeted or been mentioned in a tweet are actor nodes. The created network is directed with edges 
of different types representing retweets, quote tweets, mentions and replies to other users. Users who have tweeted 
without relations to other users will appear in the network graph as isolate nodes.
}
\note{
When creating twitter actor networks, a network with additional user information can be generated using the
\code{\link{AddUserData}} function. Additional calls can be made to the twitter API to get information
about users that were identified as nodes during network creation but did not tweet (meaning no user profile 
information was initially collected for them).
}
\examples{
\dontrun{
# create a twitter actor network graph and output to console additional information 
# during network creation (verbose)
actorNetwork <- twitterData \%>\% Create("actor")

# network
# actorNetwork$nodes
# actorNetwork$edges
}

}
