% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Collect.twitter.R
\name{Collect.twitter}
\alias{Collect.twitter}
\title{Collect tweet data from twitter search}
\usage{
\method{Collect}{twitter}(credential, searchTerm = "",
  searchType = "recent", numTweets = 100, includeRetweets = TRUE,
  retryOnRateLimit = FALSE, writeToFile = FALSE, verbose = FALSE,
  ...)
}
\arguments{
\item{credential}{A \code{credential} object generated from \code{Authenticate} with class name \code{"twitter"}.}

\item{searchTerm}{Character string. Specifies a twitter search term. For example, \code{"Australian politics"} or 
the hashtag \code{"#auspol"}.}

\item{searchType}{Character string. Returns filtered tweets as per search type \code{recent}, \code{mixed} or 
\code{popular}. Default type is \code{recent}.}

\item{numTweets}{Numeric. Specifies how many tweets to be collected. Defaults is \code{100}.}

\item{includeRetweets}{Logical. Specifies if the search should filter out retweets. Defaults is \code{TRUE}.}

\item{retryOnRateLimit}{Logical. Default is \code{FALSE}.}

\item{writeToFile}{Logical. Write collected data to file. Default is \code{FALSE}.}

\item{verbose}{Logical. Output additional information about the data collection. Default is \code{FALSE}.}

\item{...}{Arguments passed on to \code{rtweet::search_tweets}
\describe{
  \item{geocode}{Geographical limiter of the template
"latitude,longitude,radius" e.g., \code{geocode =
"37.78,-122.40,1mi"}.}
  \item{max_id}{Character, returns results with an ID less
than (that is, older than) or equal to `max_id`.  Especially
useful for large data returns that require multiple iterations
interrupted by user time constraints. For searches exceeding
18,000 tweets, users are encouraged to take advantage of rtweet's
internal automation procedures for waiting on rate limits by
setting \code{retryonratelimit} argument to TRUE.  It some cases,
it is possible that due to processing time and rate limits,
retrieving several million tweets can take several hours or even
multiple days. In these cases, it would likely be useful to
leverage \code{retryonratelimit} for sets of tweets and
\code{max_id} to allow results to continue where previous efforts
left off.}
  \item{parse}{Logical, indicating whether to return parsed
data.frame, if true, or nested list, if false. By default,
\code{parse = TRUE} saves users from the wreck of time and
frustration associated with disentangling the nasty nested list
returned from Twitter's API. As Twitter's APIs are subject to
change, this argument would be especially useful when changes to
Twitter's APIs affect performance of internal parsers. Setting
\code{parse = FALSE} also ensures the maximum amount of possible
information is returned. By default, the rtweet parse process
returns nearly all bits of information returned from
Twitter. However, users may occasionally encounter new or
omitted variables. In these rare cases, the nested list object
will be the only way to access these variables.}
}}
}
\value{
A data.frame object with class names \code{"datasource"} and \code{"twitter"}.
}
\description{
This function collects tweet data based on search terms and structures the data into a dataframe with 
the class names \code{"datasource"} and \code{"twitter"}.

The twitter Standard search API sets a rate limit of 180 requests every 15 minutes. A maximum of 100 tweets can be 
collected per search request meaning the maximum number of tweets per operation is 18000 / 15 minutes. More tweets 
can be collected by using \code{retryOnRateLimit = TRUE} parameter which will cause the collection to pause if the 
rate limit is reached and resume when the rate limit resets (in approximately 15 minutes). Alternatively the twitter 
API parameter \code{since_id} can be used in a later session to resume a twitter search collection from the last 
tweet previously collected as tweet status id's are sequential. The Standard API only returns tweets for the last 
7 days.

All of the search query operators available through the twitter API can be used in the \code{searchTerm} field. 
For example, to search for tweets containing the term \code{"love"} or \code{"hate"} the \code{"OR"} operator can be 
used in the term field: \code{searchTerm = "love OR hate"}. For more information refer to the twitter API 
documentation for query operators: \url{https://developer.twitter.com/en/docs/tweets/search/guides/standard-operators}.
}
\note{
Additional parameters passed to this function in the ellipsis \code{...} will also be passed to the Twitter 
search API request. Most parameters have been covered but a complete list can be found here: 
\url{https://developer.twitter.com/en/docs/tweets/search/api-reference/get-search-tweets}
A useful additional parameter is \code{language} allowing the user can restrict tweets returned to a particular 
language using an ISO 639-1 code. For example, to restrict a search to tweets in English the value 
\code{language = "en"} can be passed to this function.
}
\examples{
\dontrun{
# search and collect 100 recent tweets for the hashtag #auspol
myTwitterData <- twitterAuth \%>\% 
  Collect(searchTerm = "#auspol", searchType = "recent", numTweets = 100, verbose = TRUE, 
          includeRetweets = FALSE, retryOnRateLimit = TRUE, writeToFile = TRUE)
}

}
