% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Authenticate.R
\name{Authenticate}
\alias{Authenticate}
\title{Create a credential object to access social media APIs}
\usage{
Authenticate(socialmedia, ...)
}
\arguments{
\item{socialmedia}{Character string. Identifier for social media API to authenticate with. Supported social media
are \code{"twitter"}, \code{"youtube"} and \code{"reddit"}.}

\item{...}{Optional parameters to pass to functions providied by supporting R packages that are used for social media 
API access.}
}
\description{
\code{Authenticate} creates a \code{credential} object that enables R to make authenticated calls to social media
APIs. A \code{credential} object is a S3 object containing authentication related information such as an access 
token or key, and a class name identifying the social media that grants authentication. \code{Authenticate} is the 
first step of the \code{Authenticate}, \code{\link{Collect}} and \code{\link{Create}} workflow.

Refer to \code{\link{Authenticate.twitter}}, \code{\link{Authenticate.youtube}} and 
\code{\link{Authenticate.reddit}} for parameters and usage.
}
