% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_handling.R
\name{lookup_table}
\alias{lookup_table}
\title{Summary table of simulation parameters}
\usage{
lookup_table(
  data,
  project,
  scenario,
  pop = "Population 1",
  SVs = c("SV1"),
  save2disk = TRUE,
  dir_out = "ProcessedData"
)
}
\arguments{
\item{data}{The output from \code{collate_dat}}

\item{project}{Vortex project name (used to name the output)}

\item{scenario}{Vortex scenario name (used to name the output)}

\item{pop}{The name of the pop to be used as reference}

\item{SVs}{The parameters to include in the table}

\item{save2disk}{Whether to save the output to disk, default: TRUE}

\item{dir_out}{The local path to store the output. Default: ProcessedData}
}
\value{
A data.frame with scenario names and parameter values
}
\description{
\code{lookup_table} creates a table that summarises simulation parameters.
The final table will have a line for each scenario and one column for each
parameter requested with \code{SVs}.
}
\details{
If the name of the populations were changed, the user has to indicate a
population to be used as reference, otherwise \code{lookup_table} will look
for a population named 'Population 1' (i.e. Vortex default name for the first
population).

\code{lookup_table} reports the values of SVs at year zero. This is done
because parameters may take value 'zero' if the relevant population
goes extinct.There are cases where Vortex may not evaluate some parameters at
year 0. This may happen, for example, when a population is empty at
initialization (i.e. the initial population size is zero), or when K is set
to zero at the beginning of the simulation. The user should check the values
reported and check the Vortex input files if these do not look correct.

\code{SVs} can be any variable included in the data, including GS or PS set up
in Vortex.
}
\examples{
# Using Pacioni et al. example data. See ?pac.clas for more details.
data(pac.clas)
lkup.st.classic <- lookup_table(data=pac.clas, project='Pacioni_et_al',
                   scenario='ST_Classic', pop='Population 1',
                   SVs=c('SV1', 'SV2', 'SV3', 'SV4', 'SV5', 'SV6', 'SV7'),
                   save2disk=FALSE)
}
