% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tables.R
\name{tab_counts_one_cor}
\alias{tab_counts_one_cor}
\title{Count values by a metric column that will be split into groups}
\usage{
tab_counts_one_cor(
  data,
  col,
  cross,
  prop = "total",
  percent = TRUE,
  values = c("n", "p"),
  labels = TRUE,
  clean = TRUE,
  ...
)
}
\arguments{
\item{data}{A tibble.}

\item{col}{The column holding factor values.}

\item{cross}{The metric column that will be split into groups at the median.}

\item{prop}{The basis of percent calculation: "total" (the default), "cols", or "rows".}

\item{percent}{Proportions are formatted as percent by default. Set to FALSE to get bare proportions.}

\item{values}{The values to output: n (frequency) or p (percentage) or both (the default).}

\item{labels}{If TRUE (default) extracts labels from the attributes, see \link{codebook}.}

\item{clean}{Prepare data by \link{data_clean}.}

\item{...}{Placeholder to allow calling the method with unused parameters from \link{tab_counts}.}
}
\value{
A volker tibble.
}
\description{
Count values by a metric column that will be split into groups
}
\examples{
library(volker)
data <- volker::chatgpt

tab_counts_one_cor(data, adopter, sd_age)

}
\keyword{internal}
