% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GenSimplex.R
\name{GenSimplex}
\alias{GenSimplex}
\title{Generator function for simplices}
\usage{
GenSimplex(dimension, repr)
}
\arguments{
\item{dimension}{The dimension of the unit simplex.}

\item{repr}{A string to declare the representation. It has to be \code{'H'} for H-representation or \code{'V'} for V-representation.}
}
\value{
A polytope class representing the \eqn{d}-dimensional unit simplex in H- or V-representation.
}
\description{
This function can be used to generate the \eqn{d}-dimensional unit simplex in H- or V-representation.
}
\examples{
# generate a 10-dimensional simplex in H-representation
PolyList = GenSimplex(10, 'H')

# generate a 20-dimensional simplex in V-representation
P = GenSimplex(20, 'V')
}
