% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GenCube.R
\name{GenCube}
\alias{GenCube}
\title{Generator function for hypercubes}
\usage{
GenCube(dimension, repr)
}
\arguments{
\item{dimension}{The dimension of the hypercube}

\item{repr}{A string to declare the representation. It has to be \code{'H'} for H-representation or \code{'V'} for V-representation.}
}
\value{
A polytope class representing the unit \eqn{d}-dimensional hypercube in H- or V-representation.
}
\description{
This function can be used to generate the \eqn{d}-dimensional unit hypercube \eqn{[-1,1]^d} in H- or V-representation.
}
\examples{
# generate a 10-dimensional hypercube in H-representation
P = GenCube(10, 'H')

# generate a 15-dimension hypercube in V-representation
P = GenCube(15, 'V')
}
