% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/significance_subset.R
\name{significance_subset}
\alias{significance_subset}
\title{Extract a subset population}
\usage{
significance_subset(polar, significance = NULL, output = "pvalues")
}
\arguments{
\item{polar}{A polar object including expression data from groups of
interest. Created by \code{\link{polar_coords}}.}

\item{significance}{Which significance factors to subset to. If NULL 
levels(syn_polar@polar$sig)[1] is selected.}

\item{output}{What object to return. Options are "pvals", "padj", "data",
"df" for subset dataframes, or "polar" to subset the entire 'volc3d' class
object.}
}
\description{
Subsets data according to the significance groups.
}
\examples{
data(example_data)
syn_polar <- polar_coords(outcome = syn_example_meta$Pathotype,
                          data = t(syn_example_rld))

subset <- significance_subset(syn_polar, "L+", "df")
}
\references{
Lewis, Myles J., et al. (2019).
\href{https://pubmed.ncbi.nlm.nih.gov/31461658/}{
Molecular portraits of early rheumatoid arthritis identify clinical and
treatment response phenotypes.}
\emph{Cell reports}, \strong{28}:9
}
