% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interp_df.R
\name{interp_df}
\alias{interp_df}
\title{Inperpolate data frames}
\usage{
interp_df(
  x,
  compact.to,
  id = colnames(x)[1],
  colnum = NULL,
  drop.x = TRUE,
  drop.zeros = FALSE,
  to.data.frame = TRUE,
  round.off = NULL,
  weight = NULL,
  mc.cores = 1
)
}
\arguments{
\item{x}{A data frame.}

\item{compact.to}{Proportion of remaining points after interpolation. If equals to 1 and keep.zeros = TRUE, the original vector is presented.}

\item{id}{The identification column. Default: \code{colname} of the first column of \code{x}.}

\item{colnum}{A \code{char} vector indicating the numeric colnames. If \code{NULL}, uses the columns of the \code{numeric} class.}

\item{drop.x}{Logical. Drop columns containing .x? Default: \code{TRUE}.}

\item{drop.zeros}{Logical. Drop repeated zeros or keep 1 zero per null set? Default: \code{FALSE}.}

\item{to.data.frame}{Logical. Should return a data frame? If \code{FALSE} returns a list. Default: \code{TRUE}.}

\item{round.off}{Number of decimal places of the interpolated \code{y}. Default: \code{NULL}.}

\item{weight}{Vector of weights with same length of \code{y}. Default: \code{NULL}.}

\item{mc.cores}{The number of cores to mclapply. Default: \code{1}.}
}
\value{
A data frame of interpolated values with nrow near to \code{compact.to*length(x)}.
}
\description{
Interpolate data frames using multicore, compressing to \code{compact.to} fraction. May remove zeros.
}
\examples{
library(voice)

# get path to audio file
path2wav <- list.files(system.file('extdata', package = 'wrassp'),
pattern = glob2rx('*.wav'), full.names = TRUE)

# getting Media data frame via lean call
M <- extract_features(dirname(path2wav), features = c('f0','fmt'),
mc.cores = 1, verbose = FALSE)

\donttest{
(cM.df <- interp_df(M[,-(1:2)], 0.1, mc.cores = 1))
(cM.df2 <- interp_df(M[,-(1:2)], 0.1, drop.x = FALSE, mc.cores = 1))

dim(M)
dim(cM.df)
dim(cM.df2)
(cM.list <- interp_df(M[,-(1:2)], 0.1, to.data.frame = FALSE, mc.cores = 1))
}
}
\seealso{
\code{interp}, \code{interp_mc}
}
