% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_local_importance.R
\name{plot.local_importance}
\alias{plot.local_importance}
\title{Plot Local Variable Importance measure}
\usage{
\method{plot}{local_importance}(x, ...)
}
\arguments{
\item{x}{object returned from `local_variable_importance()` function}

\item{...}{other parameters}
}
\value{
a ggplot2 object
}
\description{
Function plot.local_importance plots local importance measure based on Ceteris Paribus profiles.
}
\examples{

library("DALEX")
data(apartments)

library("randomForest")
apartments_rf_model <- randomForest(m2.price ~ construction.year + surface +
                                    floor + no.rooms, data = apartments)

explainer_rf <- explain(apartments_rf_model, data = apartmentsTest[,2:5],
                        y = apartmentsTest$m2.price)

new_apartment <- data.frame(construction.year = 1998, surface = 88, floor = 2L, no.rooms = 3)

library("ingredients")
profiles <- ceteris_paribus(explainer_rf, new_apartment)

library("vivo")
measure <- local_variable_importance(profiles, apartments[,2:5],
                          absolute_deviation = TRUE, point = TRUE, density = FALSE)

plot(measure)


}
