% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/snv_location.R
\name{snv_location}
\alias{snv_location}
\title{snv_location}
\usage{
snv_location(df)
}
\arguments{
\item{df}{A rearranged dataframe}
}
\value{
A plot showing the location and frequency of SNVs found across samples
}
\description{
Reads in the vcf dataframe and generates a plot showing the frequency and location of SNVs
}
\examples{
# Example 1:
df <- data.frame(sample = c("m1", "m1", "m1", "m1", "m1",
                            "m2", "m2", "m2", "m2", "m2"),
                 CHROM = c("PB1", "PB1", "PB2", "PB2", "PB2",
				                    "PB1", "PB1", "PB2", "PB2", "PB2"),
                 POS = c(234, 266, 117, 134, 180,
				                  234, 266, 199, 88, 180),
                 major = c("G", "G", "A", "A", "C",
				                    "G", "G", "A", "G", "C"),
			            minor = c("A", "A", "G", "G", "T",
				                    "A", "A", "G", "A", "T"),
				          ALT_TYPE = c("minor", "minor", "minor", "minor", "minor",
				                       "minor", "minor", "minor", "major", "minor"),
				          minorfreq = c(0.010, 0.022, 0.043, 0.055, 0.011,
				                        0.010, 0.022, 0.043, 0.055, 0.011),
				          majorfreq = c(0.990, 0.978, 0.957, 0.945, 0.989,
				                        0.990, 0.978, 0.957, 0.945, 0.989)
)

df

snv_location(df)

# Example 2:
snv_location(head(example_filtered_SNV_df, n=20))

}
