% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_clustering.R
\name{annotate_clusters}
\alias{annotate_clusters}
\title{Annotate data frame with clusters}
\usage{
annotate_clusters(df, cluster_labels, long = TRUE, selected_clusters = NULL)
}
\arguments{
\item{df}{a data frame}

\item{cluster_labels}{list of cluster labels, automatically converted to factor.}

\item{long}{if \code{TRUE}, returned data frame will be in long format. See details for spec. Default is \code{TRUE}.}

\item{selected_clusters}{optional cluster labels to filter}
}
\value{
a wide or long data frame
}
\description{
Annotate data frame with clusters
}
\details{
Long data frame will have columns: \code{Cluster}, \code{Measurement} and \code{Value}.
}
\examples{
dmat <- compute_dmat(iris, "euclidean", TRUE, c("Petal.Length", "Sepal.Length"))
res <- compute_clusters(dmat, "complete")
cluster_labels <- cut_clusters(res, 2)
annotated_data <- annotate_clusters(iris[, c("Petal.Length", "Sepal.Length")], cluster_labels)
head(annotated_data)
}
