% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vdist-normal.R
\name{vdist_normal_plot}
\alias{vdist_normal_plot}
\alias{vdist_normal_perc}
\alias{vdist_normal_prob}
\title{Visualize normal distribution}
\usage{
vdist_normal_plot(mean = 0, sd = 1, print_plot = TRUE)

vdist_normal_perc(
  probs = 0.95,
  mean = 0,
  sd = 1,
  type = c("lower", "upper", "both"),
  print_plot = TRUE
)

vdist_normal_prob(
  perc = 3,
  mean = 0,
  sd = 1,
  type = c("lower", "upper", "both"),
  print_plot = TRUE
)
}
\arguments{
\item{mean}{Mean of the normal distribution.}

\item{sd}{Standard deviation of the normal distribution.}

\item{print_plot}{logical; if \code{TRUE}, prints the plot else returns a plot object.}

\item{probs}{Probability value.}

\item{type}{Lower tail, upper tail or both.}

\item{perc}{Quantile value.}
}
\description{
Visualize how changes in mean and standard deviation affect the
shape of the normal distribution. Compute & visualize quantiles out of given
probability  and probability from a given quantile.
}
\examples{
# visualize normal distribution
vdist_normal_plot()
vdist_normal_plot(mean = 2, sd = 0.6)

# visualize quantiles out of given probability
vdist_normal_perc(0.95, mean = 2, sd = 1.36)
vdist_normal_perc(0.3, mean = 2, sd = 1.36, type = 'upper')
vdist_normal_perc(0.95, mean = 2, sd = 1.36, type = 'both')

# visualize probability from a given quantile
vdist_normal_prob(3.78, mean = 2, sd = 1.36)
vdist_normal_prob(3.43, mean = 2, sd = 1.36, type = 'upper')
vdist_normal_prob(c(-1.74, 1.83), type = 'both')

}
\seealso{
\code{\link[stats]{Normal}}
}
