% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/collapse.R
\name{collapse}
\alias{collapse}
\title{Collapse the vistla tree into a pairwise graph}
\usage{
collapse(x, aggregate = c("max", "sum", "none"))
}
\arguments{
\item{x}{vistla object or a vistla_hierarchy object to collapse.}

\item{aggregate}{score aggregation mode.
"max" is the maximal score for this edge over all paths in the tree.
For raw vistla scores it means the score of the widest path this edge was a part of;
for ensemble scores, it corresponds to the count of the most often appearing path with this edge.
"sum" is the sum of scores. Makes little sense for raw vistla scores; for ensemble scores it corresponds
to the total count of this edge over all paths in the ensemble.
"none" returns a vector of scores over all paths, which can be processed anyhow the user desires.}
}
\value{
A pairlist representation of the graph resulting from the tree collapse.
 The result is a data frame with the following columns.
 \code{A} & \code{B} are the ends of the edge, in order where A is closer to root than B
 (interpretation depends on the \code{flow} parameter used in \code{\link{vistla}} invocation);
 \code{score} is the score aggregated according to the \code{aggregate} argument;
 finally \code{paths} is the count of paths which included this edge.
}
\description{
Collapse the vistla tree into a pairwise graph
}
\examples{
\dontrun{
 data(junction)
 v<-vistla(Y~.,data=junction)
 collapse(v)
}
}
