% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hc_vistime.R
\name{hc_vistime}
\alias{hc_vistime}
\title{Create a Timeline rendered by Highcharts.js}
\usage{
hc_vistime(
  data,
  col.event = "event",
  col.start = "start",
  col.end = "end",
  col.group = "group",
  col.color = "color",
  col.tooltip = "tooltip",
  optimize_y = TRUE,
  title = NULL,
  show_labels = TRUE,
  ...
)
}
\arguments{
\item{data}{\code{data.frame} that contains the data to be visualized}

\item{col.event}{(optional, character) the column name in \code{data} that contains event
names. Default: \emph{event}.}

\item{col.start}{(optional, character) the column name in \code{data} that contains start
dates. Default: \emph{start}.}

\item{col.end}{(optional, character) the column name in \code{data} that contains end dates.
Default: \emph{end}.}

\item{col.group}{(optional, character) the column name in \code{data} to be used for
grouping. Default: \emph{group}.}

\item{col.color}{(optional, character) the column name in \code{data} that contains colors
for events. Default: \emph{color}, if not present, colors are chosen via
\code{RColorBrewer}.}

\item{col.tooltip}{(optional, character) the column name in \code{data} that contains the
mouseover tooltips for the events. Default: \emph{tooltip}, if not present,
then tooltips are build from event name and date.}

\item{optimize_y}{(optional, logical) distribute events on y-axis by smart heuristic (default),
otherwise use order of input data.}

\item{title}{(optional, character) the title to be shown on top of the timeline.
Default: \code{NULL}.}

\item{show_labels}{(optional, boolean) choose whether or not event labels shall be
visible. Default: \code{TRUE}.}

\item{...}{for deprecated arguments up to vistime 1.1.0 (like events, colors, ...)}
}
\value{
\code{hc_vistime} returns an object of class \code{highchart} and \code{htmlwiget}
}
\description{
Provide a data frame with event data to create a visual and interactive timeline plot.
Simplest drawable dataframe can have columns `event` and `start`.
}
\examples{
# presidents and vice presidents
pres <- data.frame(
  Position = rep(c("President", "Vice"), each = 3),
  Name = c("Washington", rep(c("Adams", "Jefferson"), 2), "Burr"),
  start = c("1789-03-29", "1797-02-03", "1801-02-03"),
  end = c("1797-02-03", "1801-02-03", "1809-02-03"),
  color = c("#cbb69d", "#603913", "#c69c6e")
)

hc_vistime(pres, col.event = "Position", col.group = "Name", title = "Presidents of the USA")
}
