% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vis_dat.R
\name{vis_dat}
\alias{vis_dat}
\title{Visualises a data.frame to tell you what it contains.}
\usage{
vis_dat(x, sort_type = TRUE, palette = "default", warn_large_data = TRUE,
  large_data_size = 9e+05)
}
\arguments{
\item{x}{a data.frame object}

\item{sort_type}{logical TRUE/FALSE. When TRUE (default), it sorts by the
type in the column to make it easier to see what is in the data}

\item{palette}{character "default", "qual" or "cb_safe". "default" (the
default) provides the stock ggplot scale for separating the colours.
"qual" uses an experimental qualitative colour scheme for providing
distinct colours for each Type. "cb_safe" is a set of colours that are
appropriate for those with colourblindness. "qual" and "cb_safe" are drawn
from http://colorbrewer2.org/.}

\item{warn_large_data}{logical default is TRUE}

\item{large_data_size}{integer default is 900000, this can be changed.}
}
\value{
\code{ggplot2} object displaying the type of values in the data frame and
the position of any missing values.
}
\description{
\code{vis_dat} gives you an at-a-glance ggplot object of what is inside a
dataframe. Cells are coloured according to what class they are and whether
the values are missing. As \code{vis_dat} returns a ggplot object, it is very
easy to customize and change labels, and customize the plot
}
\examples{

vis_dat(airquality)

# experimental colourblind safe palette
vis_dat(airquality, palette = "cb_safe")
vis_dat(airquality, palette = "qual")

}
\seealso{
\code{\link[=vis_miss]{vis_miss()}}
}
