% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pie_chart.R
\name{pie_chart}
\alias{pie_chart}
\title{pie_chart}
\usage{
pie_chart(
  data,
  ordinalAccessor,
  valueAccessor,
  mainTitle = "",
  subTitle = "",
  accessibility = list(),
  props = list(),
  ...
)
}
\arguments{
\item{data}{required to be a valid, R data frame. Data used to create chart, an array of objects which includes keys that map to chart accessors.}

\item{ordinalAccessor}{String. Key used to determine chart's categorical property.}

\item{valueAccessor}{String. Key used to determine chart's numeric property.}

\item{mainTitle}{String. The dynamic tag of title for the map (or you can create your own separately). See \code{highestHeadingLevel} prop for how tags get assigned.}

\item{subTitle}{String. The dynamic tag for a sub title for the map (or you can create your own separately). See \code{highestHeadingLevel} prop for how tags get assigned.}

\item{accessibility}{List(). Manages messages and settings for chart accessibility, see \href{https://github.com/visa/visa-chart-components/tree/master/packages/pie-chart#accessibility-props}{object definition}}

\item{props}{List(). A valid R list with additional property configurations, see all props for \href{https://github.com/visa/visa-chart-components/tree/master/packages/pie-chart}{@visa/pie-chart}}

\item{...}{All other props passed into the function will be passed through to the chart, see all props for \href{https://github.com/visa/visa-chart-components/tree/master/packages/pie-chart}{@visa/pie-chart}.}
}
\value{
a visaChart htmlwidget object for plotting a pie chart
}
\description{
R wrapper for \href{https://github.com/visa/visa-chart-components/tree/master/packages/pie-chart}{@visa/pie-chart} via \href{https://www.htmlwidgets.org/}{htmlwidgets}.

Here is an example of pie-chart in action:

\if{html}{\figure{pie-chart-1.png}{options: width=400 alt="example pie chart"}}
}
\details{
To see all available options for the chart properties/API see \href{https://github.com/visa/visa-chart-components/tree/master/packages/pie-chart}{@visa/pie-chart}.
}
\examples{
library(dplyr)
data.frame (HairEyeColor) \%>\%
 filter(Hair=="Blond", Sex=="Male") \%>\%
 mutate(blueEyes = if_else(Eye=="Blue", "Blue","Other")) \%>\%
 group_by(blueEyes, Hair, Sex) \%>\%
 summarise(FreqSum=sum(Freq), n=n()) \%>\%
 pie_chart(
  "blueEyes",
  "FreqSum",
  mainTitle="How many males with Blonde hair have Blue eyes?",
  sortOrder="desc"
 )
}
