% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visHclust.R
\name{visHclust}
\alias{visHclust}
\alias{visHclust.default}
\alias{visHclust.data.frame}
\alias{visHclust.dist}
\alias{visHclust.hclust}
\title{Visualize Hierarchical cluster analysis.}
\usage{
visHclust(object, ...)

\method{visHclust}{default}(object, ...)

\method{visHclust}{data.frame}(object, main = "", submain = "",
  footer = "", distColumns = NULL, distMethod = "euclidean",
  hclustMethod = "complete", cutree = 0, tooltipColumns = 1:ncol(object),
  colorEdges = "black", colorGroups = substr(rainbow(cutree), 1, 7),
  highlightNearest = TRUE, horizontal = FALSE, minNodeSize = 50,
  maxNodeSize = 200, nodesPopSize = TRUE, height = "600px",
  width = "100\%", export = TRUE, ...)

\method{visHclust}{dist}(object, data = NULL, main = "", submain = "",
  footer = "", cutree = 0, hclustMethod = "complete",
  tooltipColumns = if (!is.null(data)) {     1:ncol(data) } else {     NULL },
  colorEdges = "black", colorGroups = substr(rainbow(cutree), 1, 7),
  highlightNearest = TRUE, horizontal = FALSE, minNodeSize = 50,
  maxNodeSize = 200, nodesPopSize = TRUE, height = "600px",
  width = "100\%", export = TRUE, ...)

\method{visHclust}{hclust}(object, data = NULL, main = "", submain = "",
  footer = "", cutree = 0, tooltipColumns = if (!is.null(data)) {    
  1:ncol(data) } else {     NULL }, colorEdges = "black",
  colorGroups = substr(rainbow(cutree), 1, 7), highlightNearest = TRUE,
  horizontal = FALSE, minNodeSize = 50, maxNodeSize = 200,
  nodesPopSize = TRUE, height = "600px", width = "100\%", export = TRUE,
  ...)
}
\arguments{
\item{object}{\code{hclust | dist | data.frame}.}

\item{...}{Don't use}

\item{main}{Title. See \link{visNetwork}}

\item{submain}{Subtitle. See \link{visNetwork}}

\item{footer}{Footer. See \link{visNetwork}}

\item{distColumns}{\code{numeric}, indice of columns used for compute distance. 
If \code{NULL} (default), keep all \code{numeric} and \code{integer} columns. 
If Not \code{NULL}, keep only  \code{numeric} and \code{integer} columns}

\item{distMethod}{\code{character}, the distance measure to be used for \code{\link[stats]{dist}} function. Default to 'euclidean'.}

\item{hclustMethod}{\code{character}, the agglomeration method to be used for \code{\link[stats]{hclust}} function. Default to 'complete'.}

\item{cutree}{\code{numeric} or \code{integer}, desired number of groups. Default to 0.}

\item{tooltipColumns}{\code{numeric}, adding mini-graphics in tooltips using \code{sparkline} ? Indice of columns used in tooltip. All by default.
So, we add boxplot / pie focus on sub-population vs all population using \code{sparkline} package. \code{NULL} to disable.}

\item{colorEdges}{\code{character}, color of edges. Default to 'black'.}

\item{colorGroups}{\code{character}, color for group in hexa ("#00FF00"). Default rainbow.}

\item{highlightNearest}{\code{boolean}, highlight sub-tree on click ? Default to \code{TRUE}.}

\item{horizontal}{\code{boolean}, default to FALSE}

\item{minNodeSize}{\code{numeric}, in case of \code{nodesPopSize}, minimum size of a node. Defaut to 50. Else \code{minNodeSize + maxNodeSize / 2}.}

\item{maxNodeSize}{\code{numeric}, in case of \code{nodesPopSize}, maximum size of a node. Defaut to 200. Else \code{ minNodeSize + maxNodeSize / 2}.}

\item{nodesPopSize}{\code{boolean}, nodes sizes depends on population ? Default to \code{TRUE}.}

\item{height}{\code{character}, default to "600px"}

\item{width}{\code{character}, default to "100\%"}

\item{export}{\code{boolean}, add button for export. Default to TRUE}

\item{data}{\code{data.frame}, data.frame with data. Only for \code{hclust} or \code{dist} object.}
}
\description{
Visualize Hierarchical cluster analysis \code{hclust}. This function compute distance using \code{dist}, and
Hierarchical cluster analysis using \code{hclust} (from stats package or flashClust if installed), and
render the tree with visNetwork, adding informations. Can also be called on a \code{hclust} or \code{dist} object.
Needed packages : sparkline (graphics on tooltip), ggraph, igraph, flashClust
}
\examples{

\dontrun{

#--------------
# data.frame
#--------------

# default call on data.frame
visHclust(iris, cutree = 3, colorEdges = "red")

# update some parameters
visHclust(iris, cutree = 3, tooltipColumns = c(1, 5),
  colorGroups = c("red", "blue", "green"), horizontal = TRUE)
  
# no graphics on tooltip
visHclust(iris, cutree = 3, tooltipColumns = NULL,
  main = "Hclust on iris")
  
# Title(s)
visHclust(iris, cutree = 3,  main ="My_title",
          submain = "My_sub_title", footer = "My_footer")
          
# Export
visHclust(iris, cutree = 3, export = TRUE)


# update group / individual nodes
visHclust(iris, cutree = 8) \%>\% 
 visGroups(groupname = "group", color ="black", 
   shape = "triangleDown", size = 75)  \%>\% 
 visGroups(groupname = "individual", 
   font = list(size = 150),
   color = list(background = "white", border = "purple", 
            highlight = "#e2e9e9", hover = "orange"), shape = "box") 

#--------------
# dist
#--------------

# without adding data & info in tooltip
visHclust(dist(iris[,1:4]), cutree = 3)
  
# adding data & info in tooltip
visHclust(dist(iris[,1:4]), cutree = 3, data = iris)

#--------------
# hclust
#--------------

# without adding data & info in tooltip
visHclust(hclust(dist(iris[,1:4])), cutree = 3)
  
# adding data & info in tooltip
visHclust(hclust(dist(iris[,1:4])), cutree = 3, data = iris) 
    
}

}
