% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cd_ens.R
\name{cd_ens}
\alias{cd_ens}
\title{CD4 Cell Count or Viral Load Ensemble Learning Through Stacking of Models.}
\usage{
cd_ens(
  outcome,
  traindata,
  viralvars,
  logbase,
  seed,
  repetitions,
  gridsize,
  mode = TRUE,
  type = TRUE
)
}
\arguments{
\item{outcome}{The name of the outcome variable.}

\item{traindata}{The training dataset.}

\item{viralvars}{Vector of variable names related to viral data.}

\item{logbase}{The base for logarithmic transformations.}

\item{seed}{Seed for reproducibility.}

\item{repetitions}{Number of repetitions for cross-validation.}

\item{gridsize}{Size of the grid for hyperparameter tuning.}

\item{mode}{Is the mode of the model regression? "regression" (TRUE) or "classification" (FALSE).}

\item{type}{Is the type of modeling ensemble? "ensemble" (TRUE) or "individual" (FALSE).}
}
\value{
A stacked ensemble model or individual models based on the specified type.
}
\description{
Stacking ensemble approach to combine predictions from various models,
allowing for grid search of tuning hyperparameters.
}
\examples{
\donttest{
library(baguette)
library(kernlab)
library(kknn)
library(ranger)
library(rules)
data("cd_train", package = "viruslearner")
outcome <- "cd_2023"
traindata <- cd_train
viralvars <- c("vl_2019", "vl_2021", "vl_2022", "vl_2023")
logbase <- 10
seed <- 1501
repetitions <- 2
gridsize <- 1
set.seed(123)
cd_ens(outcome, traindata, viralvars, logbase, seed, repetitions, gridsize, TRUE, TRUE)
}
}
