% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vos_configure.R
\name{vos_configure}
\alias{vos_configure}
\title{Configure Virtuoso Server ini file}
\usage{
vos_configure(dirs_allowed = getwd(), gigs_ram = 2,
  template = find_virtuoso_ini(), db_dir = vos_db())
}
\arguments{
\item{dirs_allowed}{Paths (relative or absolute) to directories from which
Virtuoso should have read and write access (e.g. for bulk uploading). Should
be specified as a single comma-separated string.}

\item{gigs_ram}{Indicate approximately the maximum GB of memory Virtuoso can
have access to.  (Used to set NumberOfBuffers & MaxDirtyBuffers in config.)}

\item{template}{Location of an existing virtuoso.ini file which will be used
as a template. By default, \code{vos_configure()} will attempt to locate the
appropriate template for your system.}

\item{db_dir}{location where \code{virtuoso.ini} file should be written.  Other
Virtuoso database log files will also be written here.}
}
\value{
Writes the requested \code{virtuoso.ini} file to the db_dir specified
and returns the path to this file.
}
\description{
Virtuoso Server configuration is determined by a virtuoso.ini file when
server starts. This file includes both system-specific information from
your install (location of server files, addons, etc) and user-configurable
parameters. This helper function provides a way to create and modify an
appropriate \code{virtuoso.ini} file.
}
\examples{
\donttest{
# can take > 5s to test
## configure with typical defaults:
vos_configure()
## Increase or decrease RAM available to virtuoso:
vos_configure(gigs_ram = 1)
}
}
\references{
\url{http://docs.openlinksw.com/virtuoso/dbadm/}
}
