% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{estimate_eif_projection}
\alias{estimate_eif_projection}
\title{Estimate projection of EIF on fully-observed variables}
\usage{
estimate_eif_projection(
  obs_grad = NULL,
  C = NULL,
  Z = NULL,
  ipc_fit_type = NULL,
  ipc_eif_preds = NULL,
  ...
)
}
\arguments{
\item{obs_grad}{the estimated (observed) EIF}

\item{C}{the indicator of coarsening (1 denotes observed, 0 denotes
unobserved).}

\item{Z}{either \code{NULL} (if no coarsening) or a matrix-like object
containing the fully observed data.}

\item{ipc_fit_type}{if "external", then use \code{ipc_eif_preds}; if "SL",
fit a SuperLearner to determine the IPC correction to the efficient
influence function.}

\item{ipc_eif_preds}{if \code{ipc_fit_type = "external"}, the fitted values
from a regression of the full-data EIF on the fully observed
covariates/outcome; otherwise, not used.}

\item{...}{other arguments to SuperLearner, if \code{ipc_fit_type = "SL"}.}
}
\value{
the projection of the EIF onto the fully-observed variables
}
\description{
Estimate projection of EIF on fully-observed variables
}
