% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/average_vim.R
\name{average_vim}
\alias{average_vim}
\title{Average multiple independent importance estimates}
\usage{
average_vim(..., weights = rep(1/length(list(...)), length(list(...))))
}
\arguments{
\item{...}{an arbitrary number of \code{vim} objects.}

\item{weights}{how to average the vims together, and must sum to 1; defaults to 1/(number of vims) for each vim, corresponding to the arithmetic mean}
}
\value{
an object of class \code{vim} containing the (weighted) average of the individual importance estimates, as well as the appropriate standard error and confidence interval.
This results in a list containing:
\itemize{
 \item{s}{ - a list of the column(s) to calculate variable importance for}
 \item{SL.library}{ - a list of the libraries of learners passed to \code{SuperLearner}}
 \item{full_fit}{ - a list of the fitted values of the chosen method fit to the full data}
 \item{red_fit}{ - a list of the fitted values of the chosen method fit to the reduced data}
 \item{est}{- a vector with the corrected estimates}
 \item{naive}{- a vector with the naive estimates}
 \item{update}{- a list with the influence curve-based updates}
 \item{mat}{ - a matrix with the estimated variable importance, the standard error, and the \eqn{(1-\alpha) \times 100}\% confidence interval}
 \item{full_mod}{ - a list of the objects returned by the estimation procedure for the full data regression (if applicable)}
 \item{red_mod}{ - a list of the objects returned by the estimation procedure for the reduced data regression (if applicable)}
 \item{alpha}{ - the level, for confidence interval calculation}
 \item{y}{ - a list of the outcomes}
}
}
\description{
Average the output from multiple calls to \code{vimp_regression}, for different independent groups, into a single estimate with a corresponding standard error and confidence interval.
}
\examples{
# generate the data
p <- 2
n <- 100
x <- data.frame(replicate(p, stats::runif(n, -5, 5)))

# apply the function to the x's
smooth <- (x[,1]/5)^2*(x[,1]+7)/5 + (x[,2]/3)^2

# generate Y ~ Normal (smooth, 1)
y <- smooth + stats::rnorm(n, 0, 1)

# set up a library for SuperLearner; note simple library for speed
library("SuperLearner")
learners <- c("SL.glm", "SL.mean")

# get estimates on independent splits of the data
samp <- sample(1:n, n/2, replace = FALSE)

# using Super Learner (with a small number of folds, for illustration only)
est_2 <- vimp_regression(Y = y[samp], X = x[samp, ], indx = 2, V = 2,
           run_regression = TRUE, alpha = 0.05,
           SL.library = learners, cvControl = list(V = 2))

est_1 <- vimp_regression(Y = y[-samp], X = x[-samp, ], indx = 2, V = 2,
           run_regression = TRUE, alpha = 0.05,
           SL.library = learners, cvControl = list(V = 2))

ests <- average_vim(est_1, est_2, weights = c(1/2, 1/2))

}
