% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample_subsets.R
\name{sample_subsets}
\alias{sample_subsets}
\title{Create necessary objects for SPVIMs}
\usage{
sample_subsets(p, gamma, n)
}
\arguments{
\item{p}{the number of covariates}

\item{gamma}{the fraction of the sample size to sample (e.g., \code{gamma = 1} means sample \code{n} subsets)}

\item{n}{the sample size}
}
\value{
a list, with elements Z (the matrix encoding presence/absence of each feature in the uniquely sampled subsets), S (the list of unique sampled subsets), W (the matrix of weights), and z_counts (the number of times each subset was sampled)
}
\description{
Creates the Z and W matrices and a list of sampled subsets, S, for SPVIM estimation.
}
\examples{
p <- 10
gamma <- 1
n <- 100
set.seed(100)
subset_lst <- sample_subsets(p, gamma, n)
}
