% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_sampled_split_predictions.R
\name{extract_sampled_split_predictions}
\alias{extract_sampled_split_predictions}
\title{Extract sampled-split predictions from a CV.SuperLearner object}
\usage{
extract_sampled_split_predictions(
  cvsl_obj = NULL,
  sample_splitting = TRUE,
  sample_splitting_folds = NULL,
  full = TRUE
)
}
\arguments{
\item{cvsl_obj}{An object of class \code{"CV.SuperLearner"}}

\item{sample_splitting}{logical; should we use sample-splitting or not?
Defaults to \code{TRUE}.}

\item{sample_splitting_folds}{A vector of folds to use for sample splitting}

\item{full}{logical; is this the fit to all covariates (\code{TRUE}) or not
(\code{FALSE})?}
}
\value{
The predictions on validation data in each split-sample fold; a
  list of length two, each element of which is a list with the predictions
  on the split-sample cross-validation data.
}
\description{
Use the cross-validated Super Learner and a set of specified sample-splitting
folds to extract cross-fitted predictions on separate splits of the data. This
is primarily for use in cases where you have already fit a CV.SuperLearner
and want to use the fitted values to compute variable importance without having
to re-fit. The number of folds used in the CV.SuperLearner must be even.
}
\seealso{
\code{\link[SuperLearner]{CV.SuperLearner}} for usage of the
  \code{CV.SuperLearner} function.
}
