% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/measure_anova.R
\name{measure_anova}
\alias{measure_anova}
\title{Estimate ANOVA decomposition-based variable importance.}
\usage{
measure_anova(
  full,
  reduced,
  y,
  C = rep(1, length(y)),
  Z = NULL,
  ipc_weights = rep(1, length(y)),
  ipc_fit_type = "external",
  ipc_eif_preds = rep(1, length(y)),
  scale = "identity",
  na.rm = FALSE,
  ...
)
}
\arguments{
\item{full}{fitted values from a regression function of the observed outcome on the full set of covariates.}

\item{reduced}{fitted values from a regression on the reduced set of observed covariates.}

\item{y}{the observed outcome.}

\item{C}{the indicator of coarsening (1 denotes observed, 0 denotes unobserved).}

\item{Z}{either \code{NULL} (if no coarsening) or a matrix-like object containing the fully observed data.}

\item{ipc_weights}{weights for inverse probability of coarsening (e.g., inverse weights from a two-phase sample) weighted estimation. Assumed to be already inverted (i.e., ipc_weights = 1 / [estimated probability weights]).}

\item{ipc_fit_type}{if "external", then use \code{ipc_eif_preds}; if "SL", fit a SuperLearner to determine the correction to the efficient influence function}

\item{ipc_eif_preds}{if \code{ipc_fit_type = "external"}, the fitted values from a regression of the full-data EIF on the fully observed covariates/outcome; otherwise, not used.}

\item{scale}{if doing an IPC correction, then the scale that the correction should be computed on (e.g., "identity"; or "logit" to logit-transform, apply the correction, and back-transform)}

\item{na.rm}{logical; should \code{NA}s be removed in computation? (defaults to \code{FALSE})}

\item{...}{other arguments to SuperLearner, if \code{ipc_fit_type = "SL"}.}
}
\value{
A named list of: (1) the estimated ANOVA (based on a one-step correction) of the fitted regression functions; (2) the estimated influence function; (3) the naive ANOVA estimate; and (4) the IPC EIF predictions.
}
\description{
Estimate ANOVA decomposition-based variable importance.
}
